#include <stdio.h>
#include <libspe.h>

// Reference to embedded SPU program
extern spe_program_handle_t hello_spu;

int
main()
{
  speid_t id[8];

  // Create SPU threads (no error checking!)
  for (int i = 0; i < 8; i++) {
    id[i] = spe_create_thread(0,           // thread group
                              &hello_spu,  // program
                              NULL,        // argp
                              NULL,        // envp
                              -1,          // processor affinity mask (ignore)
                              0);          // flags
  }

  // Wait for SPU threads to exit
  for (int i = 0; i < 8; i++) {
    spe_wait(id[i], NULL, 0);
  }

  return 0;
}
