#include <stdlib.h>
#include <unistd.h>
#include <sys/times.h>
#include "common.h"

static uint32_t ticks_per_sec;

// Returns the number of milliseconds that have elapsed since something
uint32_t
ticks() {
  struct tms t;
  return times(&t) * 1000 / ticks_per_sec;
}

// Returns a random float between 0 and 1
float
frand()
{
  return (float)rand() / RAND_MAX;
}

void
init_misc()
{
  ticks_per_sec = sysconf(_SC_CLK_TCK);

  srand(ticks());
}
