#include <spu_mfcio.h>
#include <libmisc.h>
#include "dma.h"

CONTROL_BLOCK cb __attribute__((aligned(16)));
int *data;

int main(uint64_t speid, uint64_t argp, uint64_t envp)
{
  uint32_t id;
  uintptr32_t cb_addr;
  uintptr32_t data_addr;
  uint32_t data_size;

  id = argp;

  // Read the address of the control block from the mailbox. This blocks until
  // the PPU writes to the mailbox.
  cb_addr = spu_read_in_mbox();

  // DMA in the control block and wait for it to complete
  mfc_get(&cb,         // destination local store address
          cb_addr,     // source main memory address
          sizeof(cb),  // number of bytes to transfer
          0,           // tag (0-31)
          0,           // (ignore)
          0);          // (ignore)
  mfc_write_tag_mask(1 << 0);
  mfc_read_tag_status_all();

  // Allocate a buffer to hold the data, aligned on a 2^7 (128) byte boundary
  // (no error checking!)
  data_size = cb.num_elements * ELEMENT_SIZE;
  data = malloc_align(data_size, 7);

  // Wait for mailbox message from SPU 0 indicating that data is ready. The
  // message contains the address where the data is located.
  data_addr = spu_read_in_mbox();

  // DMA in the actual data and wait for it to complete
  mfc_get(data,       // dest LS addr
          data_addr,  // source main memory addr
          data_size,  // number of bytes
          0,          // tag
          0,
          0);
  mfc_read_tag_status_all();

  // Notify SPU 0 that the data has been read via mailbox. SPU 0 doesn't care
  // what the message is so we just send junk.
  mfc_put((void *)12,
          cb.spu_control[id - 1] + 12,
          4,
          0,
          0,
          0);

  // Do processing (add 10000)
  for (int i = 0; i < cb.num_elements; i++) {
    data[i] += ADD_FACTOR;
  }

  printf("Done add\n");

  // DMA out processed data and wait for it to complete
  mfc_put(data,          // source LS addr
          cb.data_addr,  // dest main memory addr
          data_size,     // number of bytes
          0,             // tag
          0,
          0);
  mfc_read_tag_status_all();

  // Notify PPU via mailbox
  spu_write_out_mbox(0);
  return 0;
}
