#ifndef _DMA_H_
#define _DMA_H_

#include <stdint.h>

typedef uint32_t uintptr32_t;

// Size of each data element
#define ELEMENT_SIZE sizeof(int)

#define MUL_FACTOR 2
#define ADD_FACTOR 10000

/*
 * Protocol:
 *
 * On startup, each SPE thread is given an ID (starting from 0) passed in argp.
 * Each SPU waits for the address of the control block to be sent by the PPU
 * via mailbox and then copies it to local store.
 *
 * Each SPU (except for SPU 0) then waits for a second mailbox message from the
 * previous SPU in the pipeline. This message indicates that the previous SPU
 * has finished processing and contains the address of the data. (For SPU 0,
 * this is cb.data_addr.) The SPU DMAs the data to local store. When complete,
 * it (except for SPU 0) notifies the previous SPU via mailbox and starts
 * processing.
 *
 * When finished processing, it sends a mailbox message to the next SPU in the
 * pipeline, waits for an acknowledgement that data has been copied out, and
 * exits. The last SPU instead copies data back to main memory and sends a
 * mailbox to the PPU.
 */

typedef struct _CONTROL_BLOCK {
  uintptr32_t spu_ls[8];       // Memory-mapped address of SPUs' local store
  uintptr32_t spu_control[8];  // Memory-mapped address of SPUs' control area
  uint32_t num_spus;           // Number of SPUs in pipeline
  uint32_t data_addr;          // Address of data array in main memory
  uint32_t num_elements;
  uint32_t padding;            // Padding to keep struct size multiple of 16 b
} CONTROL_BLOCK;

#endif
