#include <spu_mfcio.h>
#include "common.h"

POINT a[NUM_POINTS / 2] CACHE_ALIGNED;
POINT b[NUM_POINTS] CACHE_ALIGNED;
float dist[NUM_POINTS / 2][NUM_POINTS] CACHE_ALIGNED;

CONTROL_BLOCK cb QWORD_ALIGNED;

int
main(uint64_t speid, uint64_t argp, uint64_t envp)
{
  // Get control block
  mfc_get(&cb, argp, sizeof(cb), 0, 0, 0);
  mfc_write_tag_mask(1 << 0);
  mfc_read_tag_status_all();

  // Get points (half of a, all of b)
  mfc_get(a, cb.a_addr, sizeof(a), 0, 0, 0);
  mfc_get(b, cb.b_addr, sizeof(b), 0, 0, 0);
  mfc_read_tag_status_all();

  // Calculate distances
  for (int i = 0; i < NUM_POINTS / 2; i++) {
    for (int j = 0; j < NUM_POINTS; j++) {
      dist[i][j] = distf(&a[i], &b[j]);
    }
  }

  // Write back output
  mfc_put(dist, cb.res_addr, sizeof(dist), 0, 0, 0);
  mfc_read_tag_status_all();

  return 0;
}
