#ifndef _SIM_COMMON_H_
#define _SIM_COMMON_H_

#include <stdint.h>

typedef uint32_t uintptr32_t;

#define FALSE 0
#define TRUE  1

// Number of bodies being simulated
#define NUM_BODIES  6144
// Number of bodies each SPU is responsible for
#define SPU_BODIES  (NUM_BODIES / 6)
// Integration step
#define TIMESTEP    0.01f

// Some alignment macros
#define QWORD_ALIGNED __attribute__((aligned(16)))
#define CACHE_ALIGNED __attribute__((aligned(128)))

// Representation of a 3D vector
typedef struct _VEC3D {
  float x, y, z;
} VEC3D;

// Calculates square of a float
static inline float fsqrf(float a) {
  return a * a;
}

// Control block
typedef struct _CONTROL_BLOCK {
  uintptr32_t mass_addr;
  uintptr32_t pos_addr;
  uintptr32_t vel_addr;
} QWORD_ALIGNED CONTROL_BLOCK;

#endif
