#ifndef om_cusparse_utils_
#define om_cusparse_utils_

#ifndef NDEBUG

static struct __CusparseError {
  cusparseStatus_t numeric;
  const char* string;
} __cusparseErrors[] = {
  { cusparseStatus_t(-1),                      "unknown error" },
  { CUSPARSE_STATUS_SUCCESS,                   "success" },
  { CUSPARSE_STATUS_NOT_INITIALIZED,           "library not initialized" },
  { CUSPARSE_STATUS_ALLOC_FAILED,              "resource allocation failed" },
  { CUSPARSE_STATUS_INVALID_VALUE,             "invalid value" },
  { CUSPARSE_STATUS_ARCH_MISMATCH,             "device architecture mismatch" },
  { CUSPARSE_STATUS_MAPPING_ERROR,             "mapping error" },
  { CUSPARSE_STATUS_EXECUTION_FAILED,          "kernel execution failed" },
  { CUSPARSE_STATUS_INTERNAL_ERROR,            "internal error" },
  { CUSPARSE_STATUS_MATRIX_TYPE_NOT_SUPPORTED, "matrix type not supported" }
};

static int __cusparseErrorCount = 
  sizeof(__cusparseErrors)/sizeof(__CusparseError);

#define cusparseVerify(x) do {                                                \
    cusparseStatus_t __cu_result = x;                                         \
    if (__cu_result!=CUSPARSE_STATUS_SUCCESS) {                               \
      int __cu_error_index=0;                                                 \
      for (int __cu_i=0;__cu_i<__cusparseErrorCount;__cu_i++) {               \
        if (__cusparseErrors[__cu_i].numeric==__cu_result) {                  \
          __cu_error_index=__cu_i;                                            \
          break;                                                              \
        }                                                                     \
      }                                                                       \
      fprintf(stderr,"%s:%i: error: cusparse function call failed:\n"         \
                     "  %s;\nmessage: %s\n",                                  \
              __FILE__,__LINE__,#x,__cusparseErrors[__cu_error_index].string);\
      exit(1);                                                                \
    }                                                                         \
  } while(0)
#else
#define cusparseVerify(x) do {                                                \
    x;                                                                        \
  } while(0)
#endif


#endif
