#ifndef om_cublas_utils_
#define om_cublas_utils_

#ifndef NDEBUG

static struct __CublasError {
  cublasStatus_t numeric;
  const char* string;
} __cublasErrors[] = {
  { cublasStatus_t(-1),                      "unknown error" },
  { CUBLAS_STATUS_SUCCESS,                   "success" },
  { CUBLAS_STATUS_NOT_INITIALIZED,           "library not initialized" },
  { CUBLAS_STATUS_ALLOC_FAILED,              "resource allocation failed" },
  { CUBLAS_STATUS_INVALID_VALUE,             "invalid value" },
  { CUBLAS_STATUS_ARCH_MISMATCH,             "device architecture mismatch" },
  { CUBLAS_STATUS_MAPPING_ERROR,             "mapping error" },
  { CUBLAS_STATUS_EXECUTION_FAILED,          "kernel execution failed" },
  { CUBLAS_STATUS_INTERNAL_ERROR,            "internal error" }
};

static int __cublasErrorCount = 
  sizeof(__cublasErrors)/sizeof(__CublasError);

#define cublasVerify(x) do {                                                \
    cublasStatus_t __cu_result = x;                                         \
    if (__cu_result!=CUBLAS_STATUS_SUCCESS) {                               \
      int __cu_error_index=0;                                                 \
      for (int __cu_i=0;__cu_i<__cublasErrorCount;__cu_i++) {               \
        if (__cublasErrors[__cu_i].numeric==__cu_result) {                  \
          __cu_error_index=__cu_i;                                            \
          break;                                                              \
        }                                                                     \
      }                                                                       \
      fprintf(stderr,"%s:%i: error: cublas function call failed:\n"         \
                     "  %s;\nmessage: %s\n",                                  \
              __FILE__,__LINE__,#x,__cublasErrors[__cu_error_index].string);\
      exit(1);                                                                \
    }                                                                         \
  } while(0)
#else
#define cublasVerify(x) do {                                                \
    x;                                                                        \
  } while(0)
#endif


#endif
