#define _SVID_SOURCE
#include<stdio.h>
#include<malloc.h>
#include<math.h>
#include<stdlib.h>
#include<stdbool.h>
#include<time.h>

void eval(float* a,float b,float* c,int size) {
  for(int i=0;i<size;i++) {
    c[i]=a[i]*b;
  }
}

// CPU code //
int main() {

  srand48(time(NULL));

  // define vector size //
  const int vector_size = 10000;

  // allocate memory //
  float* vector_a = (float*)malloc(vector_size*sizeof(float));
  float* vector_c = (float*)malloc(vector_size*sizeof(float));

  float b=drand48();
  // initialize input vector //
  for(int i=0;i<vector_size;i++) {
    vector_a[i]=drand48();
  }
  // initialize output vector to 0 //
  for(int i=0;i<vector_size;i++) {
    vector_c[i]=0;
  }

  // call computation function
  eval(vector_a,b,vector_c,vector_size);

  // verify results //
  bool success=true;
  for(int i=0;i<vector_size;i++) {
    if (fabsf(vector_a[i]*b-vector_c[i])>1e-5*b) {
      printf("computation result is wrong: index=%i expected result=%g "
             "actual result=%g\n", i, vector_a[i]*b,vector_c[i]);
      success=false;
      break;
    }
  }
  if (success) {
    printf("computation result is correct.\n");
  }

  // free memory //
  free(vector_a);
  free(vector_c);

  // exit //
  return 0;
}
