/*************************************************************************************************
  Example 4            : mpi_sum_reduce.c 
  Objective            : To find sum of 'n' integers on 'p' processors
                         using MPI collective communication and communciation
                         library call ( MPI_REDUCE ).
                         This example demonstrates the use of 
                         MPI_Init
                         MPI_Comm_rank
                         MPI_Comm_size
                         MPI_Reduce
                         MPI_Finalize
  Input               : Automatic generation of input
                        The rank of each proceess is input on each process.
  Output              : Process with Rank 0 should print the sum of 'n' values.
**************************************************************************************************/

#include <stdio.h>
#include "mpi.h"

int main(int argc,char *argv[])
{
	int myRank, numProcs;
	int root = 0;
	int sum = 0;
	MPI_Status status;

	//MPI initialization
    MPI_Init(&argc,&argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &myRank);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs);

	//The Reduce
    MPI_Reduce(&myRank, &sum, 1, MPI_INT, MPI_SUM, root, MPI_COMM_WORLD);

    if (myRank == root)
	{
		printf("SUM = %d\n", sum);
	}
	
	//MPI finalization
    MPI_Finalize();
	return 0;
}




