/*************************************************************************************************
  Example 2           : mpi_sum_pt_to_pt.c
  Objective           : To find sum of 'n' integers on 'p' processors using
                        point-to-point communication libraries calls
                        This example demonstrates the use of 
                        MPI_Init
                        MPI_Comm_rank
                        MPI_Comm_size
                        MPI_Recv
                        MPI_Send
                        MPI_Finalize
  Input               : Automatic input generation
                        The rank of each process is input on each process.
  Output              : Process with Rank 0 should print the sum of 'n' values
**************************************************************************************************/

#include <stdio.h>
#include "mpi.h"

int main(int argc,char *argv[])
{
	int myRank, numProcs;
	int src, srcTag;
	int dest, destTag;
	int iProc;
	int root = 0;
	int value, sum = 0;
	MPI_Status status;

	//MPI initialization
    MPI_Init(&argc,&argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &myRank);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs); 

    if(myRank == root)
	{
		for (iProc = 1 ; iProc < numProcs ; iProc++)
		{
			src = iProc;
			srcTag = 0;
			MPI_Recv(&value, 1, MPI_INT, src, srcTag, MPI_COMM_WORLD, &status);
			sum = sum + value;
        }
        printf("MyRank = %d, SUM = %d\n", myRank, sum);
    }
    else
	{
		dest = 0;
		destTag = 0;
		MPI_Send(&myRank, 1, MPI_INT, dest, destTag, MPI_COMM_WORLD);
    }

	//MPI Finalize
    MPI_Finalize();
	return 0;
}
