/*************************************************************************************************
  Example 3           : mpi_sum_linear_topology.c 
  Objective           : To find sum of 'n' integers on 'p' processors using 
                        Point-to-Point communication library calls and linear 
                        array topology. 
                        This example demonstrates the use of 
                        MPI_Init
                        MPI_Comm_rank
                        MPI_Comm_size
                        MPI_Send
                        MPI_Recv
                        MPI_Finalize
  Input               : Automatic input generation
                        The rank of each process is input on each process.
  Output              : Process with Rank 0 should print the sum of 'n' values 
**************************************************************************************************/

#include <stdio.h>
#include "mpi.h"

int main(int argc,char *argv[])
{
	int myRank, numProcs;
	int src, srcTag;
	int dest, destTag;
	int iProc;
	int root = 0;
	int value, sum = 0;
	MPI_Status status;

	//MPI initialization
    MPI_Init(&argc,&argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &myRank);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs);
	   
    if (myRank == root)
	{
		dest = myRank + 1;
		destTag = 0;
		MPI_Send(&myRank, 1, MPI_INT, dest, destTag, MPI_COMM_WORLD);
    }
    else if (myRank < numProcs - 1)
	{
		src = myRank - 1;
		srcTag = 0;
		MPI_Recv(&value, 1, MPI_INT, src, srcTag, MPI_COMM_WORLD, &status);
		sum = myRank + value;
		dest = myRank + 1;
		destTag = 0;
		MPI_Send(&sum, 1, MPI_INT, dest, destTag, MPI_COMM_WORLD);
	}
	else
	{
		src = myRank - 1;
		srcTag = 0;
		MPI_Recv(&value, 1, MPI_INT, src, srcTag, MPI_COMM_WORLD, &status);
		sum = myRank + value;
		printf("MyRank %d Final SUM %d\n", myRank, sum);
    }

	//MPI Finalization
    MPI_Finalize();
	return 0;
}
