/*************************************************************************************************
  Example 1            : mpi_hello_world.c	
  Objective            : MPI Program to print "Hello World"
                         This example demonstrates the use of 
                         MPI_Init
                         MPI_Comm_rank
                         MPI_Comm_size
                         MPI_Send
                         MPI_Recv
                         MPI_Finalize
   Input               : Message = "Hello World" 
   Output              : Message and Rank of the process. 
**************************************************************************************************/

#include <stdio.h>
#include "mpi.h"

#define BUFFER_SIZE 12

int main(int argc, char *argv[])
{
    int myRank, numProcs, dest, src;
    int destTag, srcTag;
	int iProc;
    int root = 0;
    char message[BUFFER_SIZE], messageRecv[BUFFER_SIZE]; 
	MPI_Status status;

    //MPI initialization
    MPI_Init(&argc,&argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &myRank);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs); 

    if(myRank != 0)
    {
		sprintf(message, "Hello World");
        dest = root;
        destTag = 0;
        MPI_Send(message, BUFFER_SIZE, MPI_CHAR, dest, destTag, MPI_COMM_WORLD);
    }
    else 
    {
		for (iProc = 1 ; iProc < numProcs ; iProc++)
	    {
			src = iProc;
			srcTag = 0;
			MPI_Recv(messageRecv, BUFFER_SIZE, MPI_CHAR, src, srcTag, MPI_COMM_WORLD, &status);
			printf("%s From Processor %d \n", messageRecv, src);
        }
    }

	//Finalize
    MPI_Finalize();
	return 0;
}
