/***********************************************************************

   Example  4          : omp_sumof_elements_reduction.c

   Objective           : Write an OpenMP program to find Sum Of Elements
                         of One-Dimensional real array.
                         This example demonstrates the use of OpenMP
                         Parallel For Directive And Reduction Clause.

   Input               : No Input

   Output              : The Array Elements and Sum of array elements

   Necessary Condition : Number of threads should be less than or
                         equal to number of processors of a SMP node

**********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <omp.h>

/* Main Program */

int main()
{
	float *elements, serial_sum, sum;
	int arraySize = 100;
	int i;

	/* Set the number of threads */
	omp_set_num_threads(2);

	/* Dynamic Memory Allocation */
	elements = (float *) malloc(sizeof(float) * arraySize);
	
	/* Array Elements Initialization */
	for (i = 0; i < arraySize; i++) 
	{
		elements[i] = i * 5;
	}

	sum = 0.0;

	/* OpenMP Parallel For Directive And Reduction Section */
	#pragma omp parallel for reduction(+ : sum)
	for (i = 0; i < arraySize; i++) 
	{
		sum = sum + elements[i];
	}

	serial_sum = 0.0;

	/* Serail Calculation */
	for (i = 0; i < arraySize; i++) 
	{
		serial_sum = serial_sum + elements[i];
	}


	if (serial_sum == sum) 
	{
		printf("The Serial And Parallel Sums are equal (%f)\n", sum);
	} 
	else 
	{
		printf("The Serial And Parallel Sums are UNequal\n");
		printf("The Serial Sum is %f\n", serial_sum);
		printf("The Parallel Sum is %f\n", sum);
		return 1;
	}

	/* Freeing Memory */
	free(elements);

	return 0;
}
