/**********************************************************************
   Example 2    : omp_hello_world_student.c

   Objective    : OpenMP program to print "Hello World"
                  This example demonstrates the use of
                  omp_get_thread_num() and
				  omp_get_num_threads() calls

   Input        : No input is needed

   Output       : Each thread prints a message "Hello World" and its
                  identifier

**********************************************************************/

#include <stdio.h>
#include <omp.h>

/* Main Program */

int main()
{
	int threadID, noOfThreads;

	/* Set the number of threads */
	omp_set_num_threads(2);

	/* OpenMP Parallel Directive */
	#pragma omp parallel private(threadID)
	{
		threadID = omp_get_thread_num();
		printf("\nHello World is being  printed by the thread id %d\n", threadID);

		/* Master Thread Has Its threadID 0 */

		if (threadID == 0) {
			printf("\nMaster prints Numof threads \n");
			noOfThreads = omp_get_num_threads();
			printf("Total number of threads are %d\n", noOfThreads);
		}
	}
	return 0;
}
