/**********************************************************************
  Example 5    : omp_pi_calculation_serial.c

  Objective    : Write an OpenMP program to compute the value of pi
                 function by numerical integration of a function
                 f(x) = 4/(1+x*x ) between the limits 0 and 1
                 This example demonstrates the use of PARALLEL FOR
                 DIRECTIVE with usage of Private , Shared clause and
                 Critical Section

  Input        : User has to specify the number of intervals

  Output       : Each thread calculates the partial sum and then the master
                 thread prints the final PI value


**********************************************************************/

#include <stdio.h>
#include <omp.h>

#define PI 3.1415926538837211

/* Main Program */

int main()
{
	int numberOfIntervals, i;
	double pi, h, x;

	printf("Enter number of intervals\n");
	scanf("%d", &numberOfIntervals);

	if (numberOfIntervals <= 0) 
	{
		printf("Number of intervals should be positive integer\n");
		return 1;
	}
	pi = 0.0;
	h = 1.0 / numberOfIntervals;

	for (i = 1; i < numberOfIntervals + 1; i++) 
	{
		x = h * (i - 0.5);
		pi += 4.0 / (1 + x * x) * h;
	}
	
	printf("The value of PI is %1.16f and the error is %1.16f\n", pi, (PI - pi));

	return 0;
}
