/*****************************************************************************
   Example 7    : omp_maxof_elements_critical.c

   Objective    : Write an OpenMP program to print Largest of an element in
                  an array
                  This example demonstrates the use of
                  omp_critical section call and PARALLEL DIRECTIVE

   Input        : User has to set OMP_NUM_THREADS environment variable for
                  n Number of threads and Number of elements of the array Input
                  is generated by random numbers


   Output       : Each thread checks with its available iterations and finally
                  Master thread prints the maximum value in the array

**********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <omp.h>

#define MAXIMUM 65536

/* Main Program */

int main()
{
	int *elements, i, numberOfElements, max_value_parallel = 0, max_value_serial = 0;

	printf("Enter the number of elements\n");
	scanf("%d", &numberOfElements);

	if (numberOfElements <= 0) {
		printf("The array elements cannot be stored\n");
		return 1;
	}

	/* Dynamic Memory Allocation */
	elements = (int *) malloc(sizeof(int) * numberOfElements);

	/* Allocating Random Number Values To The Elements Of An Array */
	srand(MAXIMUM);
	for (i = 0; i < numberOfElements; i++) 
	{
		elements[i] = rand() % MAXIMUM;
	}

	if (numberOfElements == 1) {
		printf("The Largest Number In The Array is %d", elements[0]);
		return 1;
	}

	/* OpenMP Parallel For Directive And Critical Section */

	max_value_parallel = elements[0];
	//INSERT YOU CODE HERE


	/* Serial Calculation */

	max_value_serial = elements[0];
	for (i = 1; i < numberOfElements; i++) 
	{
		if (elements[i] > max_value_serial)
		{
			max_value_serial = elements[i];
		}
	}

	/* Checking For Output Validity */
	if (max_value_parallel == max_value_serial)
	{
		printf("The Max Value Is Same From Serial And Parallel OpenMP Directive (%d,%d)\n", max_value_parallel, max_value_serial);
	}
	else 
	{
		printf("\nThe Max Value Is Not Same In Serial And Parallel OpenMP Directive (%d,%d)\n", max_value_parallel, max_value_serial);
		return 1;
	}

	/* Freeing Allocated Memory */
	free(elements);

	return 0;
}
