/**********************************************************************
   Example 1    : omp_hello_world.c

   Objective    : OpenMP program to print "Hello World"
                  This example demonstrates the use of
                  omp_get_thread_num()

   Input        : No input is needed

   Output       : Each thread prints a message "Hello World" and its
                  identifier

**********************************************************************/
#include <stdio.h>
#include <omp.h>

/* Main Program */

int main()
{
	int threadID;

	
	/* Set the number of threads */
	omp_set_num_threads(2);

	/* OpenMP Parallel Directive */
	#pragma omp parallel private(threadID)
	{
		threadID = omp_get_thread_num();
		printf("\nHello World is being  printed by the thread id %d\n", threadID);
	}
	return 0;
}
