#include "RoutingTable.h"

namespace n_radix_switch {


/*
 *  Calculates routing decision and stores output port where the Flit will leave the switch.
 *  Current one implements  Dimension Ordered Routing(DOR)
 *
 *   for n-ary, k-cube, address is expressed as Sum Ai . k^i, i = 0..n-1
 *
 */

RoutingTable::RoutingTable(int n, int k, int slef_address)
{
	_n = n;
	_k = k;
	dim = pow(k, n);
	_slef_address = slef_address;
	table = new int [dim];
	for(int i=0; i<dim; i++) table[i] = -1;

}

RoutingTable::~RoutingTable()
{
	for(int i=0; i<dim; i++) EV<<i<<"-"<<table[i]<<endl;
	delete table;
}



int RoutingTable::GetOutputNumber(Flit *pFlit)
{
	int dest = pFlit->getDestination(); //destination

	if(table[dest] != -1){
		EV << "switch:" << _slef_address << "[" << table[dest] << "] -->" << dest <<  "found" << endl ;
    	return table[dest];
	}

	int swSt = pow(_k,_n-1);
	int portID;

	if( _slef_address < (_n-1)*pow(_k,_n-1) ){
		int st = _slef_address/swSt;
		int offcurrent = swSt/pow(_k,st);

		if ((_slef_address%swSt)/(int)offcurrent==dest/(int)pow(_k,_n-st))
			portID = (dest%(offcurrent*_k))/offcurrent;
		else
			portID = (dest%(offcurrent*_k))%_k + _k;

	}
	else{
		if ((dest>=(_slef_address%swSt)*_k)&&(dest<(_slef_address%swSt)*_k+_k))
			portID = dest%_k;
		else
			portID = dest%_k + _k;

	}

	EV << "switch:" << _slef_address << "[" << portID << "] -->" << dest <<  "set" << endl ;
	table[dest] = portID;
	return portID;
}

} // namespace
