#include "DestinationTag.h"

namespace n_radix_switch {


/*
 *  Calculates routing decision and stores output port where the Flit will leave the switch.
 *  Current one implements  Dimension Ordered Routing(DOR)
 *
 *   for n-ary, k-cube, address is expressed as Sum Ai . k^i, i = 0..n-1
 *
 */

DestinationTag::DestinationTag(int n, int k, int slef_address)
{
	_n = n;
	_k = k;
	dim = pow(k, n);
	_slef_address = slef_address;
}

DestinationTag::~DestinationTag()
{

}

string DestinationTag::binary( unsigned long n, unsigned int size){
    char     result[ (sizeof( unsigned long ) * 8) + 1 ];
    unsigned index  = sizeof( unsigned long ) * 8;
    result[ index ] = '\0';

    do result[ --index ] = '0' + (n & 1);
    while (n >>= 1);

    string ret = string( result + index );
    while( ret.length() < size ){ ret = "0" + ret; }
    return ret;
    }

int DestinationTag::decimal(string binary){
    int dec = 0;
    for(unsigned int counter = 0; counter < binary.size(); counter++)
        if(binary[binary.length()-1-counter] == '1')
            dec += pow(2, counter);
    return dec;
}

int DestinationTag::GetOutputNumber(Flit *pFlit)
{
	int dest = pFlit->getDestination(); //destination
	int swSt = pow(_k, _n-1); // switches per stage
	int st = _slef_address/swSt; // current stage

	int binSize = binary(pow(_k,_n)-1,0).length(); // address size
    int binSizeSt = binSize / _n; // address size per stage

    string sw_bin = binary(dest, binSize); // addres
    int ad = decimal(sw_bin.substr(st*binSizeSt, binSizeSt));

    int noInRow = _slef_address%(int)swSt;
    int groupeSize = pow(_k,_n-1)/pow(_k,st);
    int groupe = noInRow/groupeSize;

    int border = groupe*groupeSize*_k;
    int border1 = border+pow(_k,_n-st);

    if( dest < border || dest >= border1 ){
        ad += _k;
        }

    EV << "switch:" << _slef_address << "[" << ad << "] -->" << "host:" << dest <<   endl;
    return ad;
}


} // namespace
