/*
 * MatrixTranspose.cc
 *
 *  Created on: May 4, 2011
 *      Author: 121208024
 */
#include "MatrixTranspose.h"
#include <math.h>
#include <string>
using namespace std;

namespace n_radix_switch {

MatrixTranspose::MatrixTranspose(int n, int k, int self_address)
{
	dim = pow(k, n);
	_self_address = self_address;
	EV << "Uniform::GetDestination n=" << n << ", k=" << k << endl;
}

MatrixTranspose::~MatrixTranspose()
{}

string MatrixTranspose:: dec2bin( unsigned long dec, unsigned int size)
{
    char     result[ (sizeof( unsigned long ) * 8) + 1 ];
    unsigned index  = sizeof( unsigned long ) * 8;
    result[ index ] = '\0';

    do result[ --index ] = '0' + (dec & 1);
    while (dec >>= 1);

    string ret = string( result + index );
    while( ret.length() < size ){ ret = "0" + ret; }
    return ret;
}

int MatrixTranspose:: bin2dec(string binary){
    int dec = 0;
    for(unsigned int counter = 0; counter < binary.size(); counter++)
        if(binary[binary.length()-1-counter] == '1')
            dec += pow(2, counter);
    return dec;
}
string MatrixTranspose:: get_destMT(string source_addr){	//returns string dest address (MatrixTranspose)
	string dest_addr;

	   for (unsigned int i=source_addr.length()/2;i<source_addr.length();i++){
		   dest_addr += source_addr[i];
			}

	   for (unsigned int i=0;i<source_addr.length()/2;i++){
		   dest_addr += source_addr[i];
			}

	    return dest_addr;
}

int MatrixTranspose::GetDestination()
{
	int dest;
	string binary_source;
	string binary_dest;

	binary_source = dec2bin(_self_address,  dec2bin(dim-1,0).length());		//convert selfaddress in binary
	binary_dest = get_destMT(binary_source);	//returns string dest address (Bit Reversal)
	dest = bin2dec(binary_dest);

	if(dest == _self_address) {		dest = dim - dest - 1;		}

	EV << "MatrixTranspose::GetDestination " << _self_address << ":" << binary_source << "-->"<< dest << ":" << binary_dest << endl;

	return dest;
}

} // namespace

