/*
 * OmegaRoutingInit.cpp
 *
 *  Created on: 08.01.2010
 *      Author: Lucy
 */

#include "OmegaRoutingInit.h"

#include <assert.h>
#include <stdio.h>

#include "Util.h"
#include "Messages_m.h"

namespace Omega {

Define_Module(OmegaRoutingInit);

static int OmegaRoutingFunc(YARC::HeadFlit *flit, int switchId, const char *paramString) {

	int dest = flit->par("end").longValue();

	int pow2Host =  flit->par("pow2Host").longValue();

	int highbit = -1;

	if((dest&(1<<(pow2Host-1)))!=0) {

		highbit = 1;

	} else {
		highbit = 0;
	}

	assert(highbit==0||highbit==1);

	pow2Host--;
	flit->par("pow2Host").setLongValue(pow2Host);

	if(highbit == 0){
		return 1;
	} else {
		return 3;
	}

}

void OmegaRoutingInit::initialize() {
    YARC::setRoutingFunc(OmegaRoutingFunc);
}

void OmegaRoutingInit::handleMessage(cMessage *msg) {
    assert(false);
}

}
