/*
 * OmegaHost.cpp
 *
 *  Created on: 08.01.2010
 *      Author: Lucy
 */

#include "OmegaHost.h"

#include <stdio.h>
#include <assert.h>
#include <stdlib.h>

namespace Omega {

Define_Module(OmegaHost);

OmegaHost::OmegaHost(): Host(true) {

}

void OmegaHost::initialize() {
    YARC::Host::initialize();

    id = par("id");
}

std::pair<YARC::HeadFlit*, int> OmegaHost::sendNewPacket(const char (&sideband)[2]){
    if (id > 1) {
        return YARC::Host::sendNewPacket(sideband);
    }

    // Pretend the queues at the network entry points are unbounded
//    if(sideband[0]!=0){
//        return YARC::Host::sendNewPacket(sideband);
//    }

    int val = par("maxHost").longValue();

    int pow2Host = par("pow2Host").longValue();

    if (val == -1) {
        return YARC::Host::sendNewPacket(sideband);
    }

    int destHost;
    do {
        destHost = intuniform(0, val);
    } while (destHost == id);


    int packlength = 20;

    int vc = 0;

    YARC::HeadFlit *hf = new YARC::HeadFlit();

    hf->addPar("end").setLongValue(destHost);

    hf->setVC(vc);

    hf->addPar("pow2Host").setLongValue(pow2Host);

    return std::pair<YARC::HeadFlit*, int> (hf, packlength);
}

void OmegaHost::receiveNewPacket(int length, YARC::HeadFlit *head){
    assert(head->par("pow2Host").longValue()==0);

    //printf("OmegaHost id=%d RX L=%d Delay=%.3f\n", id, length, head->par(YARC::RECEIVE_TIME).doubleValue() - head->par(YARC::SEND_TIME).doubleValue());

    static int countdown = 10000;

    double tx = head->par(YARC::SEND_TIME).doubleValue();
    double rx = head->par(YARC::RECEIVE_TIME).doubleValue();
    double latency = rx - tx;

    //printf(">%.3f %.3f %d\n", tx / 20, latency, countdown);
    printf(">%.3f %.3f\n", tx / 20, latency);

    countdown--;
    if (countdown == 0) {
        exit(0);
    }
}

}
