//
//	General ASCII and related definitions
//
#define KBD_BLANK	0x20	//	Blank char
#define KBD_CR		0x0D	//	Carriage return
#define KBD_ENTER	0x0D	//	Carriage return
#define KBD_LF		0x0A	//	Line feed
#define KBD_FF		0x0C	//	Form feed
#define KBD_BKSP	0x08	//	BackSpace
#define KBD_TAB		0x09	//	Tab
#define KBD_ESC		0x1B	//	ESCape
#define KBD_DEL		0x7F	//	Delete
//
//	Single functional	key	values
//
#define KBD_F1	0x3B00
#define KBD_F2	0x3C00
#define KBD_F3	0x3D00
#define KBD_F4	0x3E00
#define KBD_F5	0x3F00
#define KBD_F6	0x4000
#define KBD_F7	0x4100
#define KBD_F8	0x4200
#define KBD_F9	0x4300
#define KBD_F10	0x4400
#define KBD_F11	0x8500
#define KBD_F12	0x8600
//
//	Alternate keypad assignements
//
#define KBD_HOME			0x4700	//	HOME key
#define KBD_CURSOR_LEFT		0x4B00	//	<-
#define KBD_END				0x4F00	//	END key
#define KBD_CURSOR_UP		0x4800	//	up arrow
#define KBD_CURSOR_DOWN		0x5000	//	down arrow
#define KBD_PAGE_UP			0x4900	//	PgUp
#define KBD_CURSOR_RIGHT	0x4D00	//	->
#define KBD_PAGE_DOWN		0x5100	//	PgDn
#define KBD_INSERT			0x5200	//	Ins
#define KBD_DELETE			0x5300	//	Del
//
//	Alt + functional key
//
#define KBD_ALT_F1	0x6800
#define KBD_ALT_F2	0x6900
#define KBD_ALT_F3	0x6A00
#define KBD_ALT_F4	0x6B00
#define KBD_ALT_F5	0x6C00
#define KBD_ALT_F6	0x6D00
#define KBD_ALT_F7	0x6E00
#define KBD_ALT_F8	0x6F00
#define KBD_ALT_F9	0x7000
#define KBD_ALT_F10	0x7100
#define KBD_ALT_F11	0x8B00
#define KBD_ALT_F12	0x8C00
//
//	Alt + normal keyboard key
//
#define KBD_ALT_1	0x7800	//	Alt	1
#define KBD_ALT_2	0x7900	//	Alt	2
#define KBD_ALT_3	0x7A00	//	Alt	3
#define KBD_ALT_4	0x7B00	//	Alt	4
#define KBD_ALT_5	0x7C00	//	Alt	5
#define KBD_ALT_6	0x7D00	//	Alt	6
#define KBD_ALT_7	0x7E00	//	Alt	7
#define KBD_ALT_8	0x7F00	//	Alt	8
#define KBD_ALT_9	0x8000	//	Alt	9
#define KBD_ALT_0	0x8100	//	Alt	0
#define KBD_ALT_MINUS 0x8200	//	Alt	-
#define KBD_ALT_EQUAL 0x8300	//	Alt	=

#define KBD_ALT_Q	0x1000
#define KBD_ALT_W	0x1100
#define KBD_ALT_E	0x1200
#define KBD_ALT_R	0x1300
#define KBD_ALT_T	0x1400
#define KBD_ALT_Y	0x1500
#define KBD_ALT_U	0x1600
#define KBD_ALT_I	0x1700
#define KBD_ALT_O	0x1800
#define KBD_ALT_P	0x1900
#define KBD_ALT_A	0x1E00
#define KBD_ALT_S	0x1F00
#define KBD_ALT_D	0x2000
#define KBD_ALT_F	0x2100
#define KBD_ALT_G	0x2200
#define KBD_ALT_H	0x2300
#define KBD_ALT_J	0x2400
#define KBD_ALT_K	0x2500
#define KBD_ALT_L	0x2600
#define KBD_ALT_Z	0x2C00
#define KBD_ALT_X	0x2D00
#define KBD_ALT		0x2E00
#define KBD_ALT_V	0x2F00
#define KBD_ALT_B	0x3000
#define KBD_ALT_N	0x3100
#define KBD_ALT_M	0x3200
//
//	Shift + functional key
//
#define KBD_SHIFT_F1	0x5400
#define KBD_SHIFT_F2	0x5500
#define KBD_SHIFT_F3	0x5600
#define KBD_SHIFT_F4	0x5700
#define KBD_SHIFT_F5	0x5800
#define KBD_SHIFT_F6	0x5900
#define KBD_SHIFT_F7	0x5A00
#define KBD_SHIFT_F8	0x5B00
#define KBD_SHIFT_F9	0x5C00
#define KBD_SHIFT_F10	0x5D00
#define KBD_SHIFT_F11	0x8700
#define KBD_SHIFT_F12	0x8800
#define KBD_SHIFT_TAB	0x0F00		//	Shift Tab(BackTab)
//
//	Ctrl + functional key
//
#define KBDTRL_F1	0x5E00
#define KBDTRL_F2	0x5F00
#define KBDTRL_F3	0x6000
#define KBDTRL_F4	0x6100
#define KBDTRL_F5	0x6200
#define KBDTRL_F6	0x6300
#define KBDTRL_F7	0x6400
#define KBDTRL_F8	0x6500
#define KBDTRL_F9	0x6600
#define KBDTRL_F10	0x6700
#define KBDTRL_F11	0x8900
#define KBDTRL_F12	0x8A00
//
//	Ctrl + keypad key
//
#define KBDTRL_HOME		0x7700	//	Ctrl Home
#define KBDTRLURLF		0x7300	//	Ctrl <-
#define KBDTRL_END		0x7500	//	Ctrl End
#define KBDTRL_PRTSC	0x7200	//	Ctrl PrtSc
#define KBDTRL_PGUP		0x8400	//	Ctrl PgUp
#define KBDTRLURRT		0x7400	//	Ctrl ->
#define KBDTRL_PGDN		0x7600	//	Ctrl PgDn
//
//	Ctrl + normal keyboard key
//
#define CTL_A	0x01
#define CTL_B	0x02
#define CTRL_C	0x03
#define CTRL_D	0x04
#define CTRL_E	0x05
#define CTRL_F	0x06
#define CTRL_G	0x07
#define CTRL_H	0x08
#define CTRL_I	0x09
#define CTRL_J	0x0A
#define CTRL_K	0x0B
#define CTRL_L	0x0C
#define CTRL_M	0x0D
#define CTRL_N	0x0E
#define CTRL_O	0x0F
#define CTRL_P	0x10
#define CTRL_Q	0x11
#define CTRL_R	0x12
#define CTRL_S	0x13
#define CTRL_T	0x14
#define CTRL_U	0x15
#define CTRL_V	0x16
#define CTRL_W	0x17
#define CTRL_X	0x18
#define CTRL_Y	0x19
#define CTRL_Z	0x1A
#define CTRL_LBR	0x1B	//	Ctrl [
#define CTRL_BKSL	0x1C	//	Ctrl \
#define CTRL_RBR	0x1D	//	Ctrl ]
#define CTRL_6		0x1E	//	Ctrl 6
#define CTRL_MINUS	0x1F	//	Ctrl -
#define CTRL_BKSP	0x7F	//	Ctrl BKSP
#define CTRL_ESC	0x1B	//	Ctrl ESC
#define CTRL_ENTER	0x0A	//	Ctrl ENTER
//
//	Used in KBDget_key function
//
#define KBDis_func_key(c)	((c)&0xFF00)
#define KBDis_ascii_key(c)	((c)&0x00FF)
extern	int
		KBDhit (void) ;
extern	int
		KBDget_key (void) ;
extern	void
		KBDflush (void) ;
