#include	<iostream.h>
#include	<fstream.h>
#include	<process.h>
#include	<string.h>
#include	<stdio.h>
#include	<conio.h>
#include	<fcntl.h>
#include <bios.h>
#include	<io.h>
#include "kbd.hpp"
#include	"diction.hpp"

unsigned int	Choice;

static	int KBDget_key(void)
{
	unsigned int ch = bioskey (_KEYBRD_READ);
	if	(KBDis_ascii_key(ch))
		ch &= 0xFF;
	return (ch);
}
//---------------------------
tree::tree()
{
	StFile=fopen("talk.dat", "rb+");
	if(!StFile)
	{
		TopRec=NULL;
		OrgTop=NULL;
		return;
	}
	Create();
}
//---------------------------
tree::~tree()
{
	if(!StFile)
		return;
	fclose(StFile);
	if(!TopRec)
		return;
	DeleteTree(TopRec);
}
//---------------------------
void	tree::Create()
{
struct	dict	Rec;

	TopRec=new struct dict;
	OrgTop=TopRec;
	fread(&Rec, 1, sizeof(struct dict), StFile);
	memcpy(TopRec, &Rec, sizeof(struct dict));
	TopRec->LeftRec=NULL;
	TopRec->RightRec=NULL;
	while((fread(&Rec, 1, sizeof(struct dict), StFile))!=0)
		do
		{
			if((strcmp(TopRec->word, Rec.word))<1)
				if(TopRec->RightRec)
				{
					TopRec=TopRec->RightRec;
					continue;
				}
				else
				{
					TopRec->RightRec=new struct dict;
					memcpy(TopRec->RightRec, &Rec, sizeof(struct dict));
					TopRec=TopRec->RightRec;
					TopRec->RightRec=NULL;
					TopRec->LeftRec=NULL;
					TopRec=OrgTop;
					break;
				}
			if(TopRec->LeftRec)
			{
				TopRec=TopRec->LeftRec;
				continue;
			}
			else
			{
				TopRec->LeftRec=new struct dict;
				memcpy(TopRec->LeftRec, &Rec, sizeof(struct dict));
				TopRec=TopRec->LeftRec;
				TopRec->LeftRec=NULL;
				TopRec->RightRec=NULL;
				TopRec=OrgTop;
				break;
			}
		}while(6);
}
//---------------------------
void tree::DeleteTree(struct dict *Top)
{
	if(Top->LeftRec)
		DeleteTree(Top->LeftRec);
	if(Top->RightRec)
		DeleteTree(Top->RightRec);
	delete Top;
}
//---------------------------
void tree::PrintRec(struct dict *PRec)
{
	cout<< "\n" << PRec->word << "\t\t : " <<PRec->descr;
}
//---------------------------
void	tree::Add()
{
	struct dict AddRec;
	char 	 Answer;

	cout<<"\n\n ---------- Adding a word ----------- ";
	cout<<"\n Enter the word: ";
	cin>>AddRec.word;
	cout<<"\n Enter descr: ";
	cin>>AddRec.descr;
	cout<<"\n\n Are You Sure (Y/N): ";
	cin>>Answer;
	if(Answer=='N' || Answer=='n')
		return;
	else cout<<"\n\n The word is added !!! ";
	AddRec.LeftRec=NULL;
	AddRec.RightRec=NULL;
	if(!StFile)
	{
		StFile=fopen("talk.dat", "wb");
		if(!StFile)
		{
			cout<<"\n\n CAN'T CREAT TALK.DAT FILE !!!\n";
			return;
		}
		fwrite(&AddRec, 1, sizeof(struct dict), StFile);
		TopRec=new struct dict;
		memcpy(TopRec, &AddRec, sizeof(struct dict));
		OrgTop=TopRec;
		return;
	}
	if(!TopRec)
	{
		TopRec=new struct dict;
		memcpy(TopRec, &AddRec, sizeof(struct dict));
		fseek(StFile, 0, SEEK_SET);
		fwrite(&AddRec, 1, sizeof(struct dict), StFile);
		OrgTop=TopRec;
		return;
	}
	do
	{
		if(!(strcmp(TopRec->word, AddRec.word)))
		{
			cout<<"\n\n Name Already Exist !!! \n";
			break;;
		}
		if((strcmp(TopRec->word, AddRec.word))<1)
			if(TopRec->RightRec)
			{
				TopRec=TopRec->RightRec;
				continue;
			}
			else
			{
				TopRec->RightRec=new struct dict;
				TopRec=TopRec->RightRec;
				memcpy(TopRec, &AddRec, sizeof(struct dict));
				fseek(StFile, 0, SEEK_END);
				fwrite(&AddRec, 1, sizeof(struct dict), StFile);
				TopRec=OrgTop;
				break;
			}
		if(TopRec->LeftRec)
		{
			TopRec=TopRec->LeftRec;
			continue;
		}
		else
		{
			TopRec->LeftRec=new struct dict;
			TopRec=TopRec->LeftRec;
			memcpy(TopRec, &AddRec, sizeof(struct dict));
			fseek(StFile, 0, SEEK_END);
			fwrite(&AddRec, 1, sizeof(struct dict), StFile);
			TopRec=OrgTop;
			break;
		}
	}while(6);
}
//---------------------------
void	tree::Search()
{
	char	Word[15], Answer;

	if(!StFile)
	{
		cout<<"\n\n Diction file is empty! \n";
		return;
	}
	if(!TopRec)
	{
		cout<<"\n\n Tree is empty! \n";
		return;
	}
	cout<<"\n\n ----------- Searching ---------- ";
	cout<<"\n Enter the word: ";
	cin>>Word;
	do
	{
		if(!(strcmp(TopRec->word, Word)))
		{
			PrintRec(TopRec);
			TopRec=OrgTop;
			break;
		}
		if((strcmp(TopRec->word, Word))<0)
			if(TopRec->RightRec)
			{
				TopRec=TopRec->RightRec;
				continue;
			}
			else
			{
				cout << "\n\n Word: " << Word << " Not found ! \n";
				TopRec=OrgTop;
				break;
			}
		if(TopRec->LeftRec)
		{
			TopRec=TopRec->LeftRec;
			continue;
		}
		else
		{
			cout << "\n\n Word: " << Word << " Not found ! \n";
			TopRec=OrgTop;
			break;
		}
	}while(6);
}
//---------------------------
void	tree::Delete()
{

	struct dict *HTop;
	char	Word[15], Answer;
	long NewLen, WritePos;
	int	FH;

	if(!StFile)
	{
		cout<<"\n\n Diction file is empty ! \n";
		return;
	}
	if(!TopRec)
	{
		cout<<"\n\n Tree is empty ! \n";
		return;
	}
	cout<<"\n\n ----------- Deleting ---------- ";
	cout<<"\n Enter word: ";
	cin>>Word;
	cout<<"\n Are You Sure (Y/N): ";
	cin>>Answer;
	if(Answer!='y' && Answer!='Y')
		return;
	if(!(strcmp(TopRec->word, Word)) && !TopRec->LeftRec && !TopRec->RightRec)
	{
		PrintRec(TopRec);
		cout<<"\n Are You Sure (Y/N): ";
		cin>>Answer;
		if(Answer!='y' && Answer!='Y')
		{
			TopRec=OrgTop;
			return;
		}
		delete TopRec;
		fclose(StFile);
		StFile=NULL;
		system("del talk.dat");
		return;
	}
	do
	{
		if(!(strcmp(TopRec->word, Word)))
		{
			PrintRec(TopRec);
			cout<<"\n Are You Sure (Y/N): ";
			cin>>Answer;
			if(Answer!='y' && Answer!='Y')
			{
				TopRec=OrgTop;
				return;
			}
			fseek(StFile, 0, SEEK_SET);
			HTop=new struct dict;
			while((fread(HTop, sizeof(struct dict), 1, StFile))>0)
			{
				if(!(strcmp(HTop->word, Word)))
				{
					WritePos=ftell(StFile);
					WritePos-=sizeof(struct dict);
					fseek(StFile, -(long)(sizeof(struct dict)), SEEK_END);
					NewLen=ftell(StFile);
					fread(HTop, 1, sizeof(struct dict), StFile);
					fseek(StFile, WritePos, SEEK_SET);
					fwrite(HTop, 1, sizeof(struct dict), StFile);
					fclose(StFile);
					FH=open("talk.Dat",O_RDWR);
					chsize(FH, NewLen);
					close(FH);
					StFile=fopen("talk.Dat","rb+");
					break;
				}
			}
			TopRec=OrgTop;
			DeleteTree(TopRec);
			Create();
			break;
		}
		if((strcmp(TopRec->word, Word))<0)
		{
			if(TopRec->RightRec)
			{
				TopRec=TopRec->RightRec;
				continue;
			}
			cout << "\n Word: \"" << Word << "\" Does't exist ! \n";
			getch();
			break;
		}
		if(TopRec->LeftRec)
		{
			TopRec=TopRec->LeftRec;
			continue;
		}
		cout <<"\n Word: \"" << Word <<"\" Does't exist ! \n";
		getch();
		break;
	}while(6);
	TopRec=OrgTop;
}
//---------------------------
void	tree::ListAll(struct dict *Top)
{

	if(!StFile)
	{
		cout<<"\n\n Diction file is empty ! \n";
		return;
	}
	if(!Top)
	{
		cout<<"\n\n Tree is empty ! \n ";
		return;
	}
	if(Top->LeftRec)
	{
		ListAll(Top->LeftRec);
	}
	PrintRec(Top);
	if(Top->RightRec)
	{
		ListAll(Top->RightRec);
	}
}
//---------------------------
void	main()
{
	char  Answer, Word[15];
	class	tree	btree;

	do
	{
		clrscr();
		cout<<"\n\n 1. Add record.";
		cout<<"\n 2. Search record.";
		cout<<"\n 3. Delete record.";
		cout<<"\n 4. List all records.";
		cout<<"\n 5. Quit.";
		cout<<"\n\n Choose: ";
		Choice = KBDget_key();
		switch(Choice)
		{
			case	'1':
				btree.Add();
				break;
			case	'2':
				btree.Search();
				getch();
				break;
			case	'3':
				btree.Delete();
				break;
			case	'4':
				btree.ListAll(btree.TopRec);
				getch();
				break;
			case '5':
				Choice= KBD_ESC;
				break;
		}
	}while(Choice!=KBD_ESC);
}