package sessions;

import java.util.concurrent.ConcurrentHashMap;

import javax.servlet.http.HttpSession;

public class SessionManager {

  private static SessionManager manager = new SessionManager();
  // why we are using ConcurrentHashMap?
  private ConcurrentHashMap<HttpSession, String> sessions = new ConcurrentHashMap<HttpSession, String>();

  public static SessionManager getInstance() {
    return manager;
  }

  private SessionManager() {

  }

  public ConcurrentHashMap<HttpSession, String> getSessions() {
    return sessions;
  }

  public void addSession(HttpSession session) {
    sessions.put(session, session.getId());
  }

  public void removeSession(HttpSession session) {
    sessions.remove(session);
  }

}
