package listeners;

import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import sessions.SessionManager;

/**
 * SessionListener is a session listener. It implements HttpSessionListener
 * interface.
 * 
 * @author Radoslav
 * 
 */

@WebListener
public class SessionListener implements HttpSessionListener {

	private SessionManager manager = SessionManager.getInstance();

	/**
	 * sessionCreated is an event which is fired whenever a session in our
	 * application is created. Web container will invoke this method when a
	 * session is created. During this event, we will add the newly created
	 * session into SessionManager object.
	 */
	@Override
	public void sessionCreated(HttpSessionEvent event) {
		manager.addSession(event.getSession());
	}

	/**
	 * sessionDestroyed is an event which is fired whenever a session in our
	 * application is about to be destroyed. Web container will invoke this
	 * method when a session is being invalidated/expired (for example when a
	 * logout action is triggered). During this event, we will remove the
	 * session from the list of active sessions in SessionManager.
	 */
	@Override
	public void sessionDestroyed(HttpSessionEvent event) {
		manager.removeSession(event.getSession());
	}

}
