package listeners;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;

import log.AuditLog;

import users.UserManagement;

/**
 * ApplicationStartedListener is a listener for application lifecycle. It
 * implements ServletContextListener interface.
 * 
 * @author Radoslav
 * 
 */
@WebListener
public final class ApplicationStartedListener implements ServletContextListener {

	private ServletContext context = null;

	/**
	 * contextInitialized is an event fired when the application is about to be
	 * started. Whenever the execution of this method is done, the application
	 * will be registered as started into web container. It is recommended that
	 * heavy operations that are executed once for the application to be
	 * executed into contextInitialized event. Currently all users and admins
	 * will be loaded during application startup and they will be stored into
	 * ServletContext
	 */
	public void contextInitialized(ServletContextEvent event) {
		context = event.getServletContext();
		AuditLog auditLog = new AuditLog(context);
		context.setAttribute("auditLog", auditLog);
		UserManagement users = new UserManagement(context);
		users.loadUsers();
		users.loadAdmins();
		context.setAttribute("users", users);
		System.out.println("application started...");
	}

	/**
	 * contextDestroyed is an event which is fired when the application is about
	 * to be stopped.
	 */
	public void contextDestroyed(ServletContextEvent event) {
		context.removeAttribute("auditLog");
		context.removeAttribute("users");
		System.out.println("application stopping...");
	}
}
