<%@page import="java.util.LinkedList"%>
<%@page import="log.AuditLog"%>
<%@page import="users.UserManagement"%>
<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8" session="true"%>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Welcome</title>
<meta name="description" content="Welcome" />
<meta name="keywords" content="css3, login, form, custom, input, submit, button, html5, placeholder" />
<meta name="author" content="Codrops" />
<link rel="shortcut icon" href="../favicon.ico">
<link rel="stylesheet" type="text/css" href="/wapp/css/style.css" />
<script src="/wapp/js/modernizr.custom.63321.js"></script>
<!--[if lte IE 7]><style>.main{display:none;} .support-note .note-ie{display:block;}</style><![endif]-->
<style>
@import url(http://fonts.googleapis.com/css?family=Raleway:400,700);

body {
	background: #7f9b4e url(/wapp/images/bg2.jpg) no-repeat center top;
	-webkit-background-size: cover;
	-moz-background-size: cover;
	background-size: cover;
}

.container>header h1,.container>header h2 {
	color: #fff;
	text-shadow: 0 1px 1px rgba(0, 0, 0, 0.7);
}
</style>
</head>
<body>	
	<div class="container">
		<header>
			<h2>Welcome, <%=session.getAttribute("username")%> </h2>
			<div class="support-note">
				<span class="note-ie">Sorry, only modern browsers.</span>
			</div>

		</header>
		<!-- what method should be used in order not to see the username/password in the url? -->
		<section class="main">
			
			<form class="form-5" action=<%=getServletContext().getContextPath() + "/public/controller"%> method="post">
				<p>
					<input type="submit" name="action" value="logout">
				</p>
			</form>
			<!-- administrators must see a monitoring button which will lead them to a table with all active sessions
				 and normal users can see only a history for their operations
			 -->
			<%
				String currentUser = (String) session.getAttribute("username");
				UserManagement users = (UserManagement) getServletContext().getAttribute("users");
				boolean isAdmin = users.isAdminUser(currentUser);
				if (isAdmin) {
			%>

					<form class="form-5" action=<%=getServletContext().getContextPath() + "/monitor/administration.jsp"%> method="post">
						<p>
							<input type="submit" name="action" value="monitoring">
						</p>						
					</form>
			<%
				} else {
					
			%>
					
			<!-- if it is a normal user get the history of the user as using AuditLog  -->	
			<form class="form-5">
					<table border="1">
   					<tr><th>operation</th><th>user</th><th>status</th><th>ip</th></tr>
				<%
					AuditLog auditLog = (AuditLog) getServletContext().getAttribute("auditLog");
				    String username = (String) session.getAttribute("username");
					LinkedList<String[]> list = auditLog.getAuditLogsForUser(username);
					for (int i = 0; i < list.size(); i++) {
						String[] log = list.get(i);
				%>
				<tr>
					<th><%=log[0]%></th>
					<th><%=log[1]%></th>
					<th><%=log[2]%></th>
					<th><%=log[3]%></th>
				</tr>
				<%
    				}
				}
   				%>

				</table>
			</form>
		</section>

	</div>

</body>
</html>