package bg.tu_sofia.java.example_4;

class Money {
	private double value;

	public Money(double val) {
		value = val;
	}

	public void reduceValue(double red) {
		value -= red;
	}

	public void setValue(double val) {
		value = val;
	}

	public double getValue() {
		return value;
	}
}

class Credit extends Thread {
	private Money accountMoney;

	public Credit(Money accountMoney) {
		this.accountMoney = accountMoney;
	}

	@Override
	public void run() {
		while (true) {
			try {
				synchronized (accountMoney) {
					while (accountMoney.getValue() > 0.0f)
						accountMoney.reduceValue(1.0f);
					System.out.println("No Money");
					//accountMoney.notify();
					accountMoney.wait();
				}
			} catch (InterruptedException e) {
				//e.printStackTrace();
				break;
			}

		}
	}
}

class Debit extends Thread {
	private Money accountMoney;

	public Debit(Money accountMoney) {
		this.accountMoney = accountMoney;
	}

	@Override
	public void run() {
		for (int i = 0; i < 100; i++) {
			try {
				synchronized (accountMoney) {
					accountMoney.setValue(100.0);
					System.out.println("Money Sent!");
					
					accountMoney.notify();
					//accountMoney.wait(200);
				}

			} catch (Exception e) {
				e.printStackTrace();
				
			}
		}

}
}
class Killer extends Thread
{
	private Thread threadToKill;
	public Killer(Thread tk)
	{
		threadToKill = tk;
	}
	@Override
	public void run() {
		while(true)
		{
			try {
				Thread.sleep(1200);
				if(threadToKill.isAlive())
				{
					System.out.println("Shooting!");
					threadToKill.interrupt();
				}
				else{
					System.out.println("Job done!");
					break;
				}
				System.out.println("Watch it dying!");
				threadToKill.join();
				System.out.println("It is dead! Yes!");
			} catch (InterruptedException e) {
				System.out.println("The killer was killed!");
				break;
			}
			
		}
	}
	
}

public class Main {

	public static void main(String[] args) {
		Money myMoney = new Money(1000.0);
		Credit s = new Credit(myMoney);
		Debit d = new Debit(myMoney);
		s.start();
		d.start();
		Killer kill = new Killer(s);
		kill.start();
		
	}

}
