package bg.tu_sofia.java.example_3;

class BankAccount {
	private float amount;

	public BankAccount(float money) {
		amount = money;
	}

	synchronized public float getMoney(float amount) {
		if (this.amount < amount)
			return 0.0f;
		else {
			this.amount -= amount;
			return amount;
		}
	}

	public float getMoneyLeft() {
		return amount;
	}
}

class CreditCard extends Thread {
	private BankAccount account;
	private String name;
	private float moneyToWithDraw;

	public CreditCard(String name, BankAccount account, float moneyToWithDraw) {
		this.account = account;
		this.name = name;
		this.moneyToWithDraw = moneyToWithDraw;
	}

	@Override
	public void run() {
		float newValue = 0;

		for (int i = 0; i < 80; i++) {
			newValue += account.getMoney(moneyToWithDraw);
			try {
				Thread.sleep(50);
			} catch (InterruptedException e) {

			}
		}
		System.out.println(name + " : Left money = " + account.getMoneyLeft()
				+ " taken money= " + newValue);
	}

}

public class Main {

	public static void main(String[] args) {
		CreditCard a, b;
		BankAccount ba = new BankAccount(10000.0f);
		try {
			a = new CreditCard("CC1", ba, 1f);
			b = new CreditCard("CC2", ba, -1f);
			System.out.println("Bank account have " + ba.getMoneyLeft());
			a.start();
			b.start();
			System.out.println("Bank account have " + ba.getMoneyLeft());
			a.join();
			b.join();
			System.out.println("Bank account have " + ba.getMoneyLeft());
		} catch (InterruptedException e) {
			System.err.println("Thread Interrupted Exception! ");
		}
	}

}
