package bg.tu_sofia.java.example_2;

class MyThread extends Thread
{
	private String name;
	public MyThread (String name)
	{
		this.name = name;
	}
	@Override
	public void run()
	{
		while(true)
		{
			
			try {
				System.out.println(name+": I am running");
				Thread.sleep(500);
				System.out.println(name+": Awake and doing some stuff!");
				if(this.isInterrupted())
				{
					System.out.println(name+": I am leaving this cruel world!");
					break;
				}
				
			} catch (InterruptedException e) {
				{
					System.out.println(name+": Somebody is trying to kill me in my sleep!");
					System.out.println(name+": I am leaving this cruel world!");
					break;
				}
			}
			
		}
	}
}
class Killer extends Thread
{
	private Thread threadToKill;
	public Killer(Thread tk)
	{
		threadToKill = tk;
	}
	@Override
	public void run() {
		while(true)
		{
			try {
				Thread.sleep(1200);
				if(threadToKill.isAlive())
				{
					System.out.println("Shooting!");
					threadToKill.interrupt();
				}
				else{
					System.out.println("Job done!");
					break;
				}
				System.out.println("Watch it dying!");
				threadToKill.join();
				System.out.println("It is dead! Yes!");
			} catch (InterruptedException e) {
				System.out.println("The killer was killed!");
				break;
			}
			
		}
	}
	
}
public class Main {

	
	public static void main(String[] args) {
		MyThread myThread = new MyThread("Thread 1");
		myThread.start();
		Killer killer = new Killer(myThread);
		killer.start();
	}

}
